package row_data_gateway;
import db_context.DbContext;
import db_context.MyExceptions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SegmentFinder {
    private static final SegmentFinder INSTANCE = new SegmentFinder();

    public static SegmentFinder getInstance() {
        return INSTANCE;
    }

    private SegmentFinder() {
    }

    public Segment findById(int id) throws SQLException, MyExceptions.NotSuchIdException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM segments WHERE id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Segment segment = new Segment();
                    segment.setId(r.getInt("id"));
                    segment.setTransport_id(r.getInt("transport_id"));
                    segment.setConnection_id(r.getInt("connection_id"));
                    segment.setAccident(r.getBoolean("accident"));
                    segment.setDamage(r.getInt("damage"));
                    segment.setTime(r.getTimestamp("time"));
                    if (r.next()) {
                        throw new RuntimeException("Move than one row was returned");
                    }
                    return segment;
                } else {
                    throw new MyExceptions.NotSuchIdException("No such segment");
                }
            }
        }
    }
}